#include <iostream>

using namespace std;

typedef struct zid
{
    int x;
    int s;
}zid;

void swap(zid* a, zid* b)
{
    zid t = *a;
    *a = *b;
    *b = t;
}

int particija (zid niz[], int low, int high)
{
    zid pivot = niz[high];
    int i = (low - 1);
 
    for (int j = low; j <= high - 1; j++)
    {
        if (niz[j].x < pivot.x)
        {
            i++;
            swap(niz[i], niz[j]);
        }
    }
    swap(niz[i + 1], niz[high]);
    return (i + 1);
}

void quickSort(zid niz[], int low, int high)
{
    if (low < high)
    {
        int pi = particija(niz, low, high);
        quickSort(niz, low, pi - 1);
        quickSort(niz, pi + 1, high);
    }
}

int main()
{
    int n;
    scanf("%d", &n);  //unos 1
    zid niz[n];
    for(int i=0;i<n;i++)
    {
        scanf("%d %d", &niz[i].x, &niz[i].s);  //unos 2
    }

    zid nizPoz[n];
    zid nizNeg[n];
    int brPoz=0;
    int brNeg=0;

    for(int i=0;i<n;i++)
    {
        if(niz[i].x>0)
        {
            nizPoz[brPoz]=niz[i];
            brPoz++;
        }
        else
        {
            nizNeg[brNeg]=niz[i];
            brNeg++;
        }
    } 
    
    quickSort(nizPoz,0,brPoz-1);
    quickSort(nizNeg,0,brNeg-1);

    //prva iteracija

    int vreme=nizPoz[0].x;
    nizPoz[0].s--;

    bool smer=false;  //true je udesno, false je ulevo
    int poz=0;
    int neg=brNeg-1;

    while(1)
    {
        if(smer)
        {
            if(nizPoz[poz].s==0)
            {
                poz++;
                if(poz==brPoz)
                {
                    break;
                }
            }
            vreme+=nizPoz[poz].x+abs(nizNeg[neg].x);
            nizPoz[poz].s--;
            smer=false;
        }
        else
        {
            if(nizNeg[neg].s==0)
            {
                neg--;
                if(neg<0)
                {
                    break;
                }
            }   
            vreme+=nizPoz[poz].x+abs(nizNeg[neg].x);
            nizNeg[neg].s--;
            smer=true;
        }
    }

    vreme%=10000000007;

    printf("%d",vreme);

    return 0;
}